/* apccomm_all.h
   Part of "APCComm" 
   Copyright (C) 2000-2025 Ralf Hoffmann
   Contact: ralf@boomerangsworld.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
  
*/

#ifndef APCCOMM_ALL_H
#define APCCOMM_ALL_H

#define MAJOR 3
#define MINOR 1
#define PATCH 3
#define AMIGA_VERSION_STR "\0$VER: apccomm 3.1.3 ("__DATE__" "__TIME__")"

#define PROTOCOL_MAJOR 3
#define PROTOCOL_MINOR 1
#define PROTOCOL_PATCH 0

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>

#ifndef _DCC
  #include <unistd.h>
#endif

#include <sys/stat.h>
#include <fcntl.h> 

/* If you change this, you also have to change the _opt.a-file! */
#define TRANSFERBLOCKSIZE 1024

// data block read/written with one OS call
#define APCCOMM_SERIAL_BLOCKSIZE 256

extern unsigned char *outblock,*inblock;
extern unsigned short outblock_size, inblock_size;  // the total size
extern unsigned short outblock_used, inblock_actual_size; // the output size used and the input size available
extern unsigned short outblock_base, inblock_base;

enum apccomm_transfer_mode {
    APCCOMM_PARALLEL,
    APCCOMM_SERIAL
};

struct apccomm_transfer_config {
    enum apccomm_transfer_mode mode;
    int serial_speed;

    int pc_useport;
    char pc_usedevice[256];
};

extern struct apccomm_transfer_config config;

typedef struct pc_file_tag {
  int fp;
  int size;
  int checksum;
  char *name;
  short opened;
} pc_file_t;

extern pc_file_t outfile;
extern pc_file_t infile;

extern char *basedir;

extern char error_message[256];

int init_outgoing_file(const char*name);
void close_outgoing_file( void );
int init_incoming_file( const char*name, int size );
void close_incoming_file( void );

void putint(unsigned char *buffer,int value);
int getint(const unsigned char *buffer);
int readtobuffer(unsigned char* buffer,int maxsize,int *return_checksum);
int writefrombuffer(const unsigned char *buffer,int size,int *return_checksum);
int init_transferblocks( void );

void putuint16( unsigned char *buffer, unsigned short value );
unsigned short getuint16( const unsigned char *buffer );

void outputInt( unsigned short offset, int value );
int  inputInt( unsigned short offset );
void outputTrailingInt( int value );
int  inputTrailingInt( void );
unsigned char *outputData( unsigned short offset );
const unsigned char *inputData( unsigned short offset );
void setOutputSize( unsigned short size );
unsigned short inputSize( void );
unsigned short maxOutputSize( void );
unsigned short maxInputSize( void );

typedef enum { APC_COMMAND_FILETRANSFER=0,
               APC_COMMAND_ERROR,
               APC_COMMAND_ENTERDIR,
               APC_COMMAND_LEAVEDIR,
               APC_COMMAND_FINISHED,
               APC_COMMAND_NOP,
               APC_COMMAND_ABORT,
               APC_COMMAND_SKIPFILE } apc_command_t;

int min(int a, int b);

/* -1 = quiet (only errors)
 *  0 = normal
 *  1 = verbose (every message)
 */

extern int verbose;

#define BE_VERBOSE ( verbose > 0)
#define BE_QUIET ( verbose < 0 )

extern int ignore_prot;

void *allocsafe( size_t size );

#define BYTESFORNUMBER(x) ( sizeof( x ) * 3 + 1 + 1 )

extern const char *aboutStr;
extern const char *aboutStr2;

#endif
