/* apccomm_am.h
   Part of "APCComm" 
   Copyright (C) 2001-2014 Ralf Hoffmann
   Contact: ralf@boomerangsworld.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
  
*/

#ifndef APCCOMM_AM_H
#define APCCOMM_AM_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos/dos.h>
#include <dos/dosasl.h>
#include <proto/dos.h>
#include <intuition/intuition.h>
#include <proto/intuition.h>
#include <exec/io.h>

int send( void );
int receive( void );

struct transfer_log {
  long files;
  unsigned long bytes;
  ULONG secs, usecs;
};

extern struct transfer_log tfl;

/* Mapping:
 * R <-> user R 0400
 * W <-> user W 0200
 * E <-> user X 0100
 * D <-> group R 0040
 * A <-> group X 0010
 * S <-> other R 0004
 * P <-> other X 0001
 * H is not mapped
 */

int permAmiga2PC(int perm);
int permPC2Amiga(int perm);

struct sendlist_elem {
  struct sendlist_elem *next;
  char *filename;
};

extern struct sendlist_elem *sendlist_head, *sendlist_tail;

void freeSendList( void );
void addSendListElem( const char *name );
short SendListIsEmpty( void );

int openDiskDevice( const char *device_name,
                    char device_number );
int closeDiskDevice( void );

extern ULONG rttags[];
extern short connect_cancel, send_cancel, receive_cancel;

extern int osversion;

extern struct IOStdReq *dd_io_req;

#endif

