/* apccomm_am_main.h
   Part of "APCComm" 
   Copyright (C) 2002-2022 Ralf Hoffmann
   Contact: ralf@boomerangsworld.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
  
*/

#ifndef APCCOMM_MAIN_H
#define APCCOMM_MAIN_H

#ifdef GUI
#include "apccomm_gui_includes.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

enum guimodes { GUIMODE_RUN = 0, GUIMODE_QUIT, GUIMODE_SEND, GUIMODE_RECEIVE };

extern enum guimodes mode;
extern int selected_lvc;
extern int direct_disk_access;
extern int adf_write_verify;
extern int min_track, max_track;
extern short adf_mode;

void requestReceiveDir( void );
void requestAndAddFiles( void );
void removeSelectedEntry( void );
void applySLVSG( void );
void showAbout( void );
void portSelected( UWORD code );
void speedSelected( UWORD code );
void menuSettings( short permanent );

#endif
