/* apccomm_am_test.c
   Part of "APCComm" 
   Copyright (C) 2002-2014 Ralf Hoffmann
   Contact: ralf@boomerangsworld.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
  
*/

#include "apccomm_am.h"
#include "apccomm_am_tr.h"
#include "apccomm_all.h"
#include <dos/dos.h>
#include <proto/dos.h>

/* just to have those symbols available, but they are not used */
int direct_disk_access = 0;
int adf_write_verify = 0;
int min_track = 0;
int max_track = 79;
short adf_mode = 0;

struct apccomm_transfer_config config;

int main( int argc, char **argv )
{
  int s1, s2, s3, oldv;
  int value;
  
  int slave = 0;
  char buffer[128];

  memset( &config, 0, sizeof( config ) );
  config.mode = APCCOMM_PARALLEL;

  if ( argc > 1 ) {
    for ( s1 = 1; s1 < argc; s1++ ) {
      if ( ( strncmp( argv[s1], "-h", 2 ) == 0 ) || ( strncmp( argv[s1], "--help", 6 ) == 0 ) ) {
        printf( "\nAPCComm test program by Ralf Hoffmann\n" );
        printf( "  Usage: %s [Option]...\n\n", argv[0] );
        printf( "   -h, --help\t\tShow this help\n" );
        printf( "   -v, --version\tShow program version\n" );
        printf( "   -c, --client\t\trun as client\n" );
        printf( "  When starting without args, this test program runs as master\n" );
        exit( 0 );
      } else if ( ( strncmp( argv[s1], "-v", 2 ) == 0 ) || ( strncmp( argv[s1], "--version", 6 ) == 0 ) ) {
        printf( "\nAPCComm test program by Ralf Hoffmann\n  Version %d.%d.%d\n", MAJOR, MINOR, PATCH );
        printf( "  Contact: ralf@boomerangsworld.de\n" );
        exit( 0 );
      } else if( ( strncmp( argv[s1], "--client", strlen( "--client" ) ) == 0 ) ||
		 ( strncmp( argv[s1], "-c", strlen( "-c" ) ) == 0 ) ) {
	slave = 1;
      }
    }
  }

  /* Parallelport initieren */
  *ddrb = 0xff;
  *ddra = 0x00;
  
  if ( slave == 1 ) {
    do {
      s2 = ( getack() << 2 ) | getvalue();
    } while ( s2 != 7 );
    printf( "Read value=11, ack=1\n" );
    printf( "When linux is telling you so, press enter" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    s1 = 0;
    oldv = s2;
    value = 0;
    while ( s1 < ( 5 * 8 ) ) {
      do {
	s2 = ( getack() << 2 ) | getvalue();
	Delay( 1 );
	s3 = ( getack() << 2 ) | getvalue();
	if ( s3 != s2 ) s2 = oldv;
      } while ( s2 == oldv );
      printf( "Read bit settings:value=%d%d, ack=%d\n", ( s2 & 0x2 ) == 0x2,( s2 & 0x1 ) == 0x1,( s2 & 0x4 ) == 0x4 );
      value += s2;
      oldv = s2;
      s1++;
    }
    printf( "Test 1 finished\n" );
    printf( "Checksum=%d, should be %d\n", value, 5 * 28 );
    printf( "When linux is telling you so, press enter" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    s1 = 0;
    while ( s1 < ( 5 * 3 * 2 ) ) {
      do {
	s2 = ( getack() << 2 ) | getvalue();
	Delay( 1 );
	s3 = ( getack() << 2 ) | getvalue();
	if ( s3 != s2 ) s2 = oldv;
      } while ( s2 == oldv );
      printf( "Read bit settings:value=%d%d, ack=%d\n", ( s2 & 0x2 ) == 0x2, ( s2 & 0x1 ) == 0x1, ( s2 & 0x4 ) == 0x4 );
      value += s2;
      oldv = s2;
      s1++;
    }
    printf( "Test 2 finished\n" );
  } else {
    printf( "Please start the linux apccomm testprogramm with option -c\n" );
    printf( "Press Enter when done" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    printf( "Starting tests...\n" );
    printf( "Bit settings:value=1111, ack=1\n" );
    putnibbleack( 15, 1 );
    printf( "Now press Enter at the pc to synchronize the client and then Enter here" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    for ( s1 = 0; s1 < 5; s1++ ) {
      for ( s2 = 0; s2 < 32; s2++ ) {
        printf( "Bit settings:value=%d%d%d%d, ack=%d\n", ( s2 & 0x8 ) == 0x8, ( s2 & 0x4 ) == 0x4, ( s2 & 0x2 ) == 0x2, ( s2 & 0x1 ) == 0x1, ( s2 & 0x10 ) == 0x10 );
	putnibbleack( s2 & 0xf, s2 >> 4 );
	sleep( 1 );
      }
    }
    printf( "Test 1 finished\n" );
    printf( "Now press Enter at the pc to synchronize the client and then Enter here" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    for ( s1 = 0; s1 < 5; s1++ ) {
      printf( "Testing ack-bit = 0\n" );
      putnibbleack( 0, 0 );
      sleep( 1 );
      printf( "Testing ack-bit = 1\n" );
      putnibbleack( 0, 1 );
      sleep( 1 );
    }
    for ( s2 = 0; s2 < 4; s2++ ) {
      for ( s1 = 0; s1 < 5; s1++ ) {
	printf( "Testing bit %d = 0\n", s2 );
	putnibbleack( 0, 0 );
	sleep( 1 );
	printf( "Testing bit %d = 1\n", s2 );
	putnibbleack( 1 << s2, 0 );
	sleep( 1 );
      }
    }
    printf( "Test 2 finished\n" );
  }
  
  return 0;
}

