/* apccomm_am_tr.h
   Part of "APCComm" 
   Copyright (C) 2000-2022 Ralf Hoffmann
   Contact: ralf@boomerangsworld.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
  
*/

#ifndef APCCOMM_AM_TR_H
#define APCCOMM_AM_TR_H

#include "apccomm_all.h"

extern int lastvalue;
extern unsigned char *ddrb;
extern unsigned char *ddra;

int getack( void );
int getvalue( void );
void setack(int value);
void putnibble(int value);
void putnibbleack(int value,int ack);
int transferblock( void );

int am_init_port( const struct apccomm_transfer_config *config );
extern int (*am_sync)( void );
extern int (*am_transferblock)( void );
extern int (*am_cleanup)( void );

/* normally only called by sendcommand() */
int sendfile(const char *name, int mode);

/* Send a command
 * arg is used for file/dirname
 */
int sendcommand(apc_command_t com,const char *arg, int mode);

int recvcommand(apc_command_t *com,char **arg, int *mode);

int recvfile( void );

#endif

