/* apccomm_gui_temp.c
   Part of "APCComm" 
   Copyright (C) 2002-2014 Ralf Hoffmann
   Contact: ralf@boomerangsworld.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
  
*/

#include "apccomm_am_main.h"
#include "apccomm_all.h"
#include <intuition/intuition.h>
#include "apccomm_am.h"
#include "apccomm_gui.h"

int ipcbClicked( void )
{
	/* routine when gadget "Ignore protection bits" is clicked. */
	
	/* The Code is meant to be the state of the checkbox, but the value is wrong
       on my 2.05 system */
    /* ignore_prot = MainWindowMsg.Code; */

    ignore_prot = ignore_prot ? 0 : 1;

    GT_SetGadgetAttrs( MainWindowGadgets[ GD_ipcb ], MainWindowWnd, NULL,
                       GTCB_Checked, ignore_prot, TAG_END, 0 );

    return 1;
}

int rdsgClicked( void )
{
	/* routine when gadget "Receive dir" is clicked. */

    return 1;
}

int rbClicked( void )
{
	/* routine when gadget "Receive" is clicked. */

    mode = GUIMODE_RECEIVE;

    return 1;
}

int sflvClicked( void )
{
	/* routine when gadget "Send files" is clicked. */
	
	selected_lvc = MainWindowMsg.Code;

    return 1;
}

int addbClicked( void )
{
	/* routine when gadget "Add" is clicked. */
    requestAndAddFiles();

    return 1;
}

int removebClicked( void )
{
	/* routine when gadget "Remove" is clicked. */
	removeSelectedEntry();

    return 1;
}

int sbClicked( void )
{
	/* routine when gadget "Send" is clicked. */
        
    mode = GUIMODE_SEND;

    return 1;
}

int gfbClicked( void )
{
	/* routine when gadget "G" is clicked. */
    requestReceiveDir();

    return 1;
}

int adfmodecbClicked( void )
{
	/* routine when gadget "read/write ADF from/to disk" is clicked. */
    direct_disk_access = direct_disk_access ? 0 : 1;

    GT_SetGadgetAttrs( MainWindowGadgets[ GD_adfmodecb ], MainWindowWnd, NULL,
                       GTCB_Checked, direct_disk_access, TAG_END, 0 );

    return 1;
}

int verifycbClicked( void )
{
	/* routine when gadget "Verify ADF when writing" is clicked. */
    adf_write_verify = adf_write_verify ? 0 : 1;

    GT_SetGadgetAttrs( MainWindowGadgets[ GD_verifycb ], MainWindowWnd, NULL,
                       GTCB_Checked, adf_write_verify, TAG_END, 0 );

    return 1;
}

int portcybClicked( void )
{
	/* routine when gadget "Port:" is clicked. */

    portSelected( MainWindowMsg.Code );
    return 1;
}

int serialspeedcybClicked( void )
{
	/* routine when gadget "Serial speed:" is clicked. */

    speedSelected( MainWindowMsg.Code );
    return 1;
}

int slvsgClicked( void )
{
	/* routine when gadget "" is clicked. */
	
	applySLVSG();

    return 1;
}

int rcbClicked( void )
{
	/* routine when gadget "Cancel" is clicked. */

    receive_cancel = 1;

    return 1;
}

int scbClicked( void )
{
	/* routine when gadget "Cancel" is clicked. */
        
    send_cancel = 1;

    return 1;
}

int conbClicked( void )
{
	/* routine when gadget "_Cancel" is clicked. */
    connect_cancel = 1;

    return 1;
}

int MainWindowItem0( void )
{
	/* routine when (sub)item "About..." is selected. */
    showAbout();

    return 1;
}

int MainWindowKeepS( void )
{
	/* routine when (sub)item "Keep settings" is selected. */

    menuSettings( 0 );

    return 1;
}

int MainWindowSaveS( void )
{
	/* routine when (sub)item "Save settings" is selected. */

    menuSettings( 1 );

    return 1;
}

int MainWindowItem1( void )
{
	/* routine when (sub)item "Quit" is selected. */
	mode = GUIMODE_QUIT;

    return 1;
}

int MainWindowCloseWindow( void )
{
	/* routine for "IDCMP_CLOSEWINDOW". */
	mode = GUIMODE_QUIT;

    return 1;
}

int Receive_filesCloseWindow( void )
{
	/* routine for "IDCMP_CLOSEWINDOW". */
        
    receive_cancel = 1;

    return 1;
}

int Send_filesCloseWindow( void )
{
	/* routine for "IDCMP_CLOSEWINDOW". */
        
    send_cancel = 1;

    return 1;
}

int ConnectWindowCloseWindow( void )
{
	/* routine for "IDCMP_CLOSEWINDOW". */
	
	connect_cancel = 1;

    return 1;
}

