/* apccomm_pc_test.c
   Part of "APCComm" 
   Copyright (C) 2002,2006,2013 Ralf Hoffmann
   Contact: ralf@boomerangsworld.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
  
*/

#include "apccomm_pc.h"
#include "apccomm_pc_tr.h"
#include <getopt.h>

#include <tavvva_ppdrv.h>

struct apccomm_transfer_config config;

int main( int argc, char *argv[] )
{
  int s1, s2, s3, oldv;
  int value;
  int useport = LPT1;
  int slave = 0;
  char buffer[128];

  memset( &config, 0, sizeof( config ) );
  config.mode = APCCOMM_PARALLEL;

  while ( 1 ) {
    int option_index;
    int c;
    unsigned long int ul_arg;
    char *endptr;
    static struct option long_options[] = {
      { "help", no_argument, NULL, 'h' },
      { "version", no_argument, NULL, 'v' },
      { "client", no_argument, NULL, 'c' },
      { "port", required_argument, NULL, 'p' },
      { NULL, 0, NULL, 0 }
    };

    c = getopt_long( argc, argv, "hvcp:", long_options, &option_index );
    if ( c == -1 ) break;

    switch( c ) {
        case 'p':
            if ( strcmp( optarg, "lpt1" ) == 0 ) useport = LPT1;
            else if ( strcmp( optarg, "lpt2" ) == 0 ) useport = LPT2;
            else if ( strncmp( optarg, "0x", 2 ) == 0 ) {
                ul_arg = strtoul( &optarg[2], &endptr, 16 );
                if (*endptr || !ul_arg  ||  ul_arg > 0xffff) {
                    fprintf( stderr, "Invalid port base address!\n"
                             "Allowed range : 0x0001 - 0xFFFF (eg. 0x378, 0x278, 0x3BC, 0xA200, ...)\n" );
                    exit( 1 );
                }
                useport = (int) ul_arg;
            } else if ( strncmp( optarg, "/dev/", 5 ) == 0 ) {
                if ( tpp_init( optarg ) ) exit ( 1 );
            } else {
                fprintf( stderr, "Invalid port! The possibilities are: lpt1, lpt2,\n"
                         "the port base address in HEX (e.g. 0x378, 0x278, 0x3BC, 0xA200, ...)\n"
                         "or the parport device (eg. /dev/parport0)\n" );
                exit( 1 );
            }
            break;
        case 'h':
            printf( "\nAPCComm test program by Ralf Hoffmann\n" );
            printf( "  Usage: %s [Option]...\n\n", argv[0] );
            printf( "   -h, --help\t\tShow this help\n" );
            printf( "   -v, --version\tShow program version\n" );
            printf( "   --port=<port>\tuse parallel port <port>\n" );
            printf( "   \t\t\t<port> can be lpt1 or lpt2\n" );
            printf( "   -c, --client\t\trun as client\n" );
            printf( "  When starting without args, this testprogram runs as master\n" );
            exit( 0 );
            break;
        case 'v':
            printf( "\nAPCComm test program by Ralf Hoffmann\n  Version %d.%d.%d\n", MAJOR, MINOR, PATCH );
            printf( "  Contact: ralf@boomerangsworld.de\n" );
            exit( 0 );
            break;
        case 'c':
            slave = 1;
            break;
        default:
            break;
    }
  }

  if ( !tpp_active() && pin_init_user( useport ) < 0 ) {
    fprintf( stderr, "can't initialize parallelport!\n" );
    exit( 0 );
  }
  /* drop root privileges needed for access to parport */
  setuid( getuid() );
  setgid( getgid() );

  if ( tpp_active() ) {
      tpp_set_data_direction( 0 );
      enable_tpp_in_tr_core();
  } else {
      pin_output_mode( LP_DATA_PINS );
  }

  if ( slave == 1 ) {
    do {
      s2 = ( getack() << 4 ) | getnibble();
    } while ( s2 != 31 );
    printf( "Read value=1111, ack=1\n" );
    printf( "When amiga is telling you so, press enter" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    s1 = 0;
    oldv = s2;
    value = 0;
    while ( s1 < ( 5 * 32 ) ) {
      do {
	s2 = ( getack() << 4 ) | getnibble();
	usleep( 1000 );
	s3 = ( getack() << 4 ) | getnibble();
	if ( s3 != s2 ) s2 = oldv;
      } while ( s2 == oldv );
      printf( "Read bit settings:value=%d%d%d%d, ack=%d\n", ( s2 & 0x8 ) == 0x8, ( s2 & 0x4 ) == 0x4, ( s2 & 0x2 ) == 0x2, ( s2 & 0x1 ) == 0x1, ( s2 & 0x10 ) == 0x10 );
      value += s2;
      oldv = s2;
      s1++;
    }
    printf( "Test 1 finished\n" );
    printf( "Checksum=%d, should be %d\n", value, 5 * 496 );
    printf( "When amiga is telling you so, press enter" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    s1 = 0;
    while ( s1 < ( 5 * 5 * 2 ) ) {
      do {
	s2 = ( getack() << 4 ) | getnibble();
	usleep( 1000 );
	s3 = ( getack() << 4 ) | getnibble();
	if ( s3 != s2 ) s2 = oldv;
      } while ( s2 == oldv );
      printf( "Read bit settings:value=%d%d%d%d, ack=%d\n", ( s2 & 0x8 ) == 0x8, ( s2 & 0x4 ) == 0x4, ( s2 & 0x2 ) == 0x2, ( s2 & 0x1 ) == 0x1, ( s2 & 0x10 ) == 0x10 );
      value += s2;
      oldv = s2;
      s1++;
    }
    printf( "Test 2 finished\n" );
  } else {
    printf( "Please start the amiga apccomm test program with option -c\n" );
    printf( "Press Enter when done" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    printf( "Starting tests...\n" );
    printf( "Bit settings:value=11, ack=1\n" );
    putvalue( 3 );
    setack( 1 );
    printf( "Now press Enter at the amiga to synchronize the client and then Enter here" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    for ( s1 = 0; s1 < 5; s1++ ) {
      for ( s2 = 0; s2 < 8; s2++ ) {
        printf( "Bit settings:value=%d%d, ack=%d\n", ( s2 & 0x2 ) == 0x2, ( s2 & 0x1 ) == 0x1, ( s2 & 0x4 ) == 0x4 );
	putvalue( s2 & 0x3 );
	setack( s2 >> 2 );
	sleep( 1 );
      }
    }
    printf( "Test 1 finished\n" );
    printf( "Now press Enter at the amiga to synchronize the client and then Enter here" );
    fflush( stdout );
    fgets( buffer, 127, stdin );
    putvalue( 0 );
    for ( s1 = 0; s1 < 5; s1++ ) {
      printf( "Testing ack-bit = 0\n" );
      setack( 0 );
      sleep( 1 );
      printf( "Testing ack-bit = 1\n" );
      setack( 1 );
      sleep( 1 );
    }
    setack( 0 );
    for ( s2 = 0; s2 < 2; s2++ ) {
      for ( s1 = 0; s1 < 5; s1++ ) {
	printf( "Testing bit %d = 0\n", s2 );
	putvalue( 0 );
	sleep( 1 );
	printf( "Testing bit %d = 1\n", s2 );
	putvalue( 1 << s2 );
	sleep( 1 );
      }
    }
    printf( "Test 2 finished\n" );
  }

  if ( tpp_active() ) tpp_exit();

  return 0;
}

