/* lvhandling.c
   Part of "APCComm" 
   Copyright (C) 2002,2006 Ralf Hoffmann
   Contact: ralf@boomerangsworld.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
  
*/
/* $Id: lvhandling.c,v 1.2 2006/01/15 22:22:27 ralf Exp $ */

#include "lvhandling.h"

#include <intuition/intuition.h>
#include <libraries/gadtools.h>
#include <proto/gadtools.h>
#include <exec/types.h>
#include <exec/memory.h>
#include <exec/execbase.h>
#include <intuition/intuition.h>
#include <proto/exec.h>
#include <exec/lists.h>
#include <string.h>
#include <stdlib.h>
#include <clib/alib_protos.h>

struct List *lvcs = NULL;

struct Node *GetHead( struct List *list )
{
  struct Node *node;
  
  if ( list == NULL ) return NULL;
  node = list->lh_Head;
  
  if ( node == NULL ) return NULL;

  if ( node->ln_Succ == NULL ) node = NULL;
  return node;
}

struct Node *GetSucc( struct Node *n )
{
  struct Node *node;

  if ( n == NULL ) return NULL;

  node = n->ln_Succ;
  
  if ( node == NULL ) return NULL;
  
  if ( node->ln_Succ == NULL ) node = NULL;
  return node;
}

void deleteLVCList( void )
{
  struct Node *node;
  
  if ( lvcs == NULL ) return;
  while ( ( node = RemTail( lvcs ) ) != NULL ) {
    free( node->ln_Name );
    free( node );
  }
  free( lvcs );
}

void initLVCList( void )
{
  if ( lvcs != NULL ) deleteLVCList();
  lvcs = (struct List*)malloc( sizeof( struct List ) );
  memset( lvcs, 0, sizeof( struct List ) );
  NewList( lvcs );
}

void addLVC( const char *name )
{
  struct Node *node;
  
  if ( lvcs == NULL ) return;
  if ( name == NULL ) return;
  
  node = (struct Node*)malloc( sizeof( struct Node ) );
  memset( node, 0, sizeof( struct Node ) );
  node->ln_Name = strdup( name );
  AddTail( lvcs, node );
}

void removeLVC( const char *name )
{
  struct Node *node;
  
  if ( lvcs == NULL ) return;
  if ( name == NULL ) return;
  node = FindName( lvcs, name );
  if ( node != NULL ) {
    Remove( node );
    free( node->ln_Name );
    free( node );
  }
}

void removeLVCAtPos( int pos )
{
  int p;
  struct Node *node;
  
  if ( lvcs == NULL ) return;
  
  p = 0;
  node = GetHead( lvcs );
  while ( p < pos ) {
    if ( node == NULL ) break;
    node = GetSucc( node );
    p++;
  }
  if ( node != NULL ) {
    Remove( node );
    free( node->ln_Name );
    free( node );
  }
}

void updateLV( struct Gadget *lv, struct Window *win )
{
  if ( lv == NULL ) return;
  if ( lvcs == NULL ) return;
  
  GT_SetGadgetAttrs( lv, win, NULL, GTLV_Labels, lvcs, TAG_END, 0 );
}

int getLVCSize( void )
{
  int size = 0;
  struct Node *node;
  
  if ( lvcs != NULL ) {
    node = GetHead( lvcs );
    while ( node != NULL ) {
      node = GetSucc( node );
      size++;
    }
  }
  return size;
}

void changeLVC( int pos, const char *ntext )
{
  int p;
  struct Node *node;
  char *tstr;
  
  if ( lvcs == NULL ) return;
  if ( ntext == NULL ) return;
  
  p = 0;
  node = GetHead( lvcs );
  while ( p < pos ) {
    if ( node == NULL ) break;
    node = GetSucc( node );
    p++;
  }
  if ( node != NULL ) {
    tstr = node->ln_Name;
    node->ln_Name = strdup( ntext );
    free( tstr );
  }
}

