/*
 *  tavvva_ppdrv - ioctl based parallel port driving library
 *                 (no direct I/O access!!!)
 *
 *  Copyright (C) 2013 Jaromir Capik <tavvva@email.cz>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __TAVVVA_PPDRV_H__
#define __TAVVVA_PPDRV_H__

#include <linux/parport.h>

#define stat_to_pin10(stat) (!!((stat) & PARPORT_STATUS_ACK))
#define stat_to_pin11(stat) ( !((stat) & PARPORT_STATUS_BUSY))
#define stat_to_pin12(stat) (!!((stat) & PARPORT_STATUS_PAPEROUT))
#define stat_to_pin13(stat) (!!((stat) & PARPORT_STATUS_SELECT))
#define stat_to_pin15(stat) (!!((stat) & PARPORT_STATUS_ERROR))

#define data_to_pin(pin,data) (!!((data) & (1 << ((pin)-2))))

#define  pin1_to_ctrl(val,ctrl) if ( !(val)) ctrl |= PARPORT_CONTROL_STROBE; else ctrl &= ~PARPORT_CONTROL_STROBE;
#define pin14_to_ctrl(val,ctrl) if (!!(val)) ctrl |= PARPORT_CONTROL_AUTOFD; else ctrl &= ~PARPORT_CONTROL_AUTOFD;
#define pin16_to_ctrl(val,ctrl) if ( !(val)) ctrl |= PARPORT_CONTROL_INIT;   else ctrl &= ~PARPORT_CONTROL_INIT;
#define pin17_to_ctrl(val,ctrl) if ( !(val)) ctrl |= PARPORT_CONTROL_SELECT; else ctrl &= ~PARPORT_CONTROL_SELECT;

#define  pin1_to_fctrl(val) ( !(val) ? PARPORT_CONTROL_STROBE : 0)
#define pin14_to_fctrl(val) (!!(val) ? PARPORT_CONTROL_AUTOFD : 0)
#define pin16_to_fctrl(val) ( !(val) ? PARPORT_CONTROL_INIT   : 0)
#define pin17_to_fctrl(val) ( !(val) ? PARPORT_CONTROL_SELECT : 0)
#define  PIN1_MASK PARPORT_CONTROL_STROBE
#define PIN14_MASK PARPORT_CONTROL_AUTOFD
#define PIN16_MASK PARPORT_CONTROL_INIT
#define PIN17_MASK PARPORT_CONTROL_SELECT

#define pin_to_data(pin,val,data) if (!!(val)) data |= (1 << ((pin)-2)); else data &= ~(1 << ((pin)-2));

int tpp_init(char *file);
int tpp_exit (void);
int tpp_active(void);
int tpp_read_control (unsigned char *ctrl);
int tpp_write_control (unsigned char ctrl);
int tpp_frobs_control (unsigned char ctrl, unsigned char mask);
int tpp_read_status (unsigned char *status);
int tpp_set_data_direction (int direction);
int tpp_write_data (unsigned char data);
unsigned char tpp_data_loopback (void);
int tpp_read_data (unsigned char *data);
int tpp_write_pin (int pin, int val);
int tpp_read_pin (int pin, int *val);

#endif
